{/ JBK 16 Client - Long file names for 16-bit applications through DDE
//
// Version 1.0 - Freeware. Please modify as needed.
//
// (c) JBK Data 1997
//     CSID 100776,1403
//     e-mail Jens_B_Kristensen@compuserve.com
/}
unit Ddeunit;
{Delphi VCL form and DDE conversation components}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DdeMan, jbkutils, StdCtrls;
var
   {Filenames (null terminated) for the application to use.
   Display longfilename to the user, use shortfilename for
   file operations behind the curtain}
   longfilename,shortfilename:tjkfilename;

type
  TDDEform = class(TForm)
    DdeLongname: TDdeClientItem;
    DdeClientConv1: TDdeClientConv;
    DdeShortname: TDdeClientItem;
    Label1: TLabel;
    Label2: TLabel;
    Ddeopenlongname: TDdeClientItem;
    Ddesavelongname: TDdeClientItem;
    procedure FormCreate(Sender: TObject);
    procedure DdeLongnameChange(Sender: TObject);
    procedure DdeShortnameChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DDEform: TDDEform;
  s:string;
implementation

{$R *.DFM}

procedure TDDEform.FormCreate(Sender: TObject);
begin
   caption:='Filename DDE Client';
   with ddeclientconv1 do
   begin
      ddeservice:='LFN32SRV';
      ddetopic:='DdeServerConv1';
      serviceapplication:='lfn32srv';
   end;

   with ddelongname do
   begin
      ddeconv:=ddeclientconv1;
      ddeitem:='DdeServerLongname';
   end;
   with ddeopenlongname do
   begin
      ddeconv:=ddeclientconv1;
      ddeitem:='DdeServerOpenLongname';
   end;
   with ddesavelongname do
   begin
      ddeconv:=ddeclientconv1;
      ddeitem:='DdeServerSaveLongname';
   end;
   with ddeshortname do
   begin
      ddeconv:=ddeclientconv1;
      ddeitem:='DdeServerShortname';
   end;
   
   with ddeclientconv1 do
   begin
      setlink('LFN32SRV','DdeServerConv1');
      if not openlink then

         messagebox(0,'Link to 32-bit DDE server not established','',mb_ok);
   end;
hide;
end;

procedure TDDEform.DdeLongnameChange(Sender: TObject);
{Important. Updates longfilename if the dialog box
was closed with the OK button}
begin
   strpcopy(longfilename,ddelongname.text);
end;

procedure TDDEform.DdeShortnameChange(Sender: TObject);
{Important. Updates shortfilename if the dialog box
was closed with the OK button}
var h:hwnd;
begin
   strpcopy(shortfilename,ddeshortname.text);
   {
   For VCL (Delphi1) applications delete last four lines and replace with
   something like this (not tested!)

   Mainform.show;
   Mainform.dofileoperation;
   }
   {Here's the OWL stuff:}
   h:=findwindow('LFNWindow',nil);
   winprocs.setfocus(h);
   {send message to main window that the filename has changed}
   sendmessage(h,wm_command,9999,0);
end;

procedure TDDEform.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
   if windows95 then ddeclientconv1.closelink;
end;

end.
